/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.domain;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class RioTopologyReader {
    private static final String TRACE_MASKT = "XPARIORT";
    private static final String TRACE_MASKF = "XPARIORF";
    private static final String TRACE_MASKD = "XPARIORD";
    private static HashMap mtmsToPortMapping = new HashMap();
    private static HashMap mtmsToCecMapping = new HashMap();
    private static HashMap portToMtmsMapping = new HashMap();
    private static String version = "Version [2.00] - 07/14/2004";
    private static String DEFAULT_RIO_TOPO_PATH = "riotopology";
    private static String ORGINAL_CONFIG_FILE_NAME = "origRioCfg";
    private static boolean parsed = false;

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                if (args[0].toLowerCase().equals("-dump")) {
                    RioTopologyReader.dumpData();
                } else if (args[0].toLowerCase().equals("-domains")) {
                    String[] ids = RioTopologyReader.getRioDomainIds();
                    System.out.println("the Domains specified in the file are");
                    int i = 0;
                    while (i < ids.length) {
                        System.out.println("Domain id [" + i + "] is " + ids[i]);
                        ++i;
                    }
                } else if (args[0].toLowerCase().equals("-lookup")) {
                    if (args.length > 2) {
                        String output = RioTopologyReader.getRioDomainForLoop(args[1], args[2]);
                        if (output == null) {
                            System.out.println("\n\nCouldn't find the domain.\n\n\nDumping all the data.\n\n");
                            RioTopologyReader.dumpData();
                        } else {
                            System.out.println("the domain id for " + args[1] + " loop " + args[2] + " is " + output);
                        }
                    } else {
                        System.out.println("provide a system and loop to look up");
                    }
                } else if (args[0].toLowerCase().equals("-mtmslist")) {
                    if (args.length > 1) {
                        List mtmsList = RioTopologyReader.getMTMSInfoForDomain(args[1]);
                        if (mtmsList == null) {
                            System.out.println("\n\nCouldn't find the domain.\n\n\nDumping all the data.\n\n");
                            RioTopologyReader.dumpData();
                        } else {
                            Iterator it = mtmsList.iterator();
                            System.out.println("The MTMS list is:");
                            while (it.hasNext()) {
                                System.out.println(it.next());
                            }
                        }
                    } else {
                        System.out.println("\n\nPlease provide a domain to look up");
                        System.out.println("\n\nDumping all the data.\n\n");
                        RioTopologyReader.dumpData();
                    }
                } else if (args[0].toLowerCase().equals("-version")) {
                    System.out.println(version);
                } else if (args[0].toLowerCase().equals("-mtmsloop")) {
                    if (args.length > 2) {
                        List mtmsList = RioTopologyReader.getMTMSInfoForLoop(args[1], args[2]);
                        if (mtmsList == null) {
                            System.out.println("\n\nCouldn't find the loop.\n\n\nDumping all the data.\n\n");
                            RioTopologyReader.dumpData();
                        } else {
                            Iterator it = mtmsList.iterator();
                            System.out.println("The MTMS list is:");
                            while (it.hasNext()) {
                                System.out.println(it.next());
                            }
                        }
                    } else {
                        System.out.println("\n\nPlease provide a domain to look up");
                        System.out.println("\n\nDumping all the data.\n\n");
                        RioTopologyReader.dumpData();
                    }
                } else if (args[0].toLowerCase().equals("-ceclist")) {
                    Trace.trace(TRACE_MASKD, "getting the ceclist");
                    String[] domainList = RioTopologyReader.getRioDomainIds();
                    int i = 0;
                    while (i < domainList.length) {
                        System.out.println("The CECs for Domain " + domainList[i] + " are:");
                        List cecList = RioTopologyReader.getCecsOnLoop(domainList[i]);
                        RioTopologyReader.dumpList(cecList);
                        System.out.println(" ");
                        ++i;
                    }
                } else {
                    System.out.println("the options are:");
                    System.out.println("-domains: lists the domains that are defined in the file");
                    System.out.println("-dump: dumps out the data for the RIO loops");
                    System.out.println("-help: displays this help info.");
                    System.out.println("-lookup %mtms% %loop% : display the rio id for the loop");
                    System.out.println("-mtmslist %domain%: displays the mtms info for the specified list");
                    System.out.println("-mtmsloop %mtms% %loop%: displays the mtms info for the specified loop");
                    System.out.println("-version: displays the version of the code");
                }
            } else {
                RioTopologyReader.dumpData();
            }
        }
        catch (Exception e) {
            System.out.println("Got the following exception");
            e.printStackTrace();
        }
    }

    public static void dumpList(List list) {
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        } else {
            System.out.println("the list was null");
        }
    }

    public static void dumpData() {
        if (!parsed) {
            RioTopologyReader.parseFile();
        }
        System.out.println(" ");
        Iterator it = mtmsToPortMapping.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            System.out.println("For loop: " + key + "");
            List list = (List)mtmsToPortMapping.get(key);
            Iterator machineIt = list.iterator();
            while (machineIt.hasNext()) {
                System.out.println("     ---> " + machineIt.next());
            }
            System.out.println("");
        }
    }

    public static String[] getRioDomainIds() {
        Trace.trace(TRACE_MASKD, "--> getRioDomainIds()");
        if (!parsed) {
            RioTopologyReader.parseFile();
        }
        ArrayList<String> loopIdList = new ArrayList<String>();
        Collection loopCollection = mtmsToPortMapping.values();
        Iterator it = loopCollection.iterator();
        while (it.hasNext()) {
            ArrayList list = (ArrayList)it.next();
            String id = (String)list.get(0);
            loopIdList.add(id);
        }
        Trace.trace(TRACE_MASKD, "<-- getRioDomainIds()");
        return loopIdList.toArray(new String[0]);
    }

    public static List getCecsOnLoop(String domainId) {
        Trace.trace(TRACE_MASKD, "--> getCecsOnLoop(" + domainId + ")");
        if (!parsed) {
            RioTopologyReader.parseFile();
        }
        List returnList = null;
        List portList = (List)portToMtmsMapping.get(domainId);
        if (portList != null) {
            Iterator mtmsIt = portList.iterator();
            while (mtmsIt.hasNext()) {
                String key = (String)mtmsIt.next();
                List cecList = (List)mtmsToCecMapping.get(key);
                if (cecList != null) {
                    Trace.trace(TRACE_MASKF, "found the entry");
                    return cecList;
                }
                Trace.trace(TRACE_MASKF, "didn't find it.  Keep going");
            }
        } else {
            Trace.trace(TRACE_MASKD, "the port mapping was null");
        }
        return returnList;
    }

    public static String getRioDomainForLoop(String mtms, String loopid) {
        String key;
        ArrayList loopData;
        if (!parsed) {
            RioTopologyReader.parseFile(mtms);
        }
        if ((loopData = (ArrayList)mtmsToPortMapping.get(key = mtms.trim() + "/" + loopid.trim())) != null) {
            return (String)loopData.get(0);
        }
        return null;
    }

    public static List getMTMSInfoForDomain(String domainRequest) {
        if (!parsed) {
            RioTopologyReader.parseFile();
        }
        Set keyList = mtmsToPortMapping.keySet();
        Iterator keyIt = keyList.iterator();
        while (keyIt.hasNext()) {
            String domainKey = (String)keyIt.next();
            List mtmsList = (List)mtmsToPortMapping.get(domainKey);
            String domainName = (String)mtmsList.get(0);
            if (!domainName.equals(domainRequest)) continue;
            return mtmsList;
        }
        return null;
    }

    public static List getMTMSInfoForLoop(String mtms, String loopid) {
        if (!parsed) {
            RioTopologyReader.parseFile();
        }
        String key = mtms.trim() + "/" + loopid.trim();
        return (ArrayList)mtmsToPortMapping.get(key);
    }

    private static void parseLoopEntry(String line, BufferedReader reader, File topoFile) throws IOException {
        ArrayList<String> mtmsList;
        ArrayList<String> portList;
        String origString;
        StringTokenizer st = new StringTokenizer(line, ",");
        String busNumber = "";
        String leadingPortLoc = "";
        String trailingPortLoc = "";
        String powerControlSystemSerial = "";
        String functionControlSystemSerial = "";
        String nodeType = "";
        int colonAt = 0;
        while (st.hasMoreElements()) {
            String parmString = st.nextToken();
            Trace.trace(TRACE_MASKD, "parmToken is " + parmString);
            colonAt = parmString.indexOf(":");
            if (colonAt >= -1) {
                if (parmString.startsWith("BusNumber:")) {
                    busNumber = parmString.substring(colonAt + 1);
                    Trace.trace(TRACE_MASKD, "setting busNumber to be " + busNumber);
                    continue;
                }
                if (parmString.startsWith("LeadingPortLoc:")) {
                    leadingPortLoc = parmString.substring(colonAt + 1);
                    Trace.trace(TRACE_MASKD, "setting leadingPortLoc to be " + leadingPortLoc);
                    continue;
                }
                if (parmString.startsWith("TrailingPortLoc:")) {
                    trailingPortLoc = parmString.substring(colonAt + 1);
                    Trace.trace(TRACE_MASKD, "setting TrailingPortLoc to be " + trailingPortLoc);
                    continue;
                }
                if (parmString.startsWith("PowerControlSystemSerial:")) {
                    powerControlSystemSerial = parmString.substring(colonAt + 1);
                    Trace.trace(TRACE_MASKD, "setting powerControlSystemSerial to be " + powerControlSystemSerial);
                    continue;
                }
                if (parmString.startsWith("NodeType:")) {
                    nodeType = parmString.substring(colonAt + 1);
                    Trace.trace(TRACE_MASKD, "setting nodeType to be " + nodeType);
                    continue;
                }
                if (parmString.startsWith("FunctionControlSystemSerial:")) {
                    functionControlSystemSerial = parmString.substring(colonAt + 1);
                    Trace.trace(TRACE_MASKD, "setting functionControlSystemSerial to be " + functionControlSystemSerial);
                    continue;
                }
                Trace.trace(TRACE_MASKD, "ignore " + parmString + " entry");
                continue;
            }
            Trace.trace(TRACE_MASKF, "there was no : in the line!!");
        }
        String key = topoFile.getName();
        key = key.replace('-', '/');
        key = key.replace('*', '-');
        key = key + "*" + busNumber;
        int index = (key = key.toLowerCase()).indexOf(origString = new String("origriocfg."));
        if (index != -1) {
            key = key.substring(origString.length());
        }
        Trace.trace(TRACE_MASKD, "the key is now " + key);
        if (mtmsToPortMapping.containsKey(key)) {
            Trace.trace(TRACE_MASKD, "just add them");
            portList = (ArrayList<String>)mtmsToPortMapping.get(key);
            portList.add(trailingPortLoc);
            portList.add(leadingPortLoc);
            Collections.sort(portList);
        } else {
            Trace.trace(TRACE_MASKD, "create the list and add them");
            portList = new ArrayList<String>(2);
            portList.add(trailingPortLoc);
            portList.add(leadingPortLoc);
            Collections.sort(portList);
            mtmsToPortMapping.put(key, portList);
        }
        if (portToMtmsMapping.containsKey(leadingPortLoc)) {
            Trace.trace(TRACE_MASKD, "just add the leading port");
            mtmsList = (ArrayList<String>)portToMtmsMapping.get(leadingPortLoc);
            mtmsList.add(key);
            Collections.sort(mtmsList);
        } else {
            Trace.trace(TRACE_MASKD, "create the list and add the leading port");
            mtmsList = new ArrayList<String>(1);
            mtmsList.add(key);
            Collections.sort(mtmsList);
            portToMtmsMapping.put(leadingPortLoc, mtmsList);
        }
        if (portToMtmsMapping.containsKey(trailingPortLoc)) {
            Trace.trace(TRACE_MASKD, "just add the trailing port");
            mtmsList = (ArrayList<String>)portToMtmsMapping.get(trailingPortLoc);
            mtmsList.add(key);
            Collections.sort(mtmsList);
        } else {
            Trace.trace(TRACE_MASKD, "create the list and add the trailing port");
            mtmsList = new ArrayList<String>(1);
            mtmsList.add(key);
            Collections.sort(mtmsList);
            portToMtmsMapping.put(trailingPortLoc, mtmsList);
        }
        if (nodeType.toLowerCase().indexOf("cec") != -1) {
            ArrayList<String> cecList;
            Trace.trace(TRACE_MASKD, "where dealing with a CEC");
            if (mtmsToCecMapping.containsKey(key)) {
                Trace.trace(TRACE_MASKD, "just add it since the entry exists");
                cecList = (ArrayList<String>)mtmsToCecMapping.get(key);
                cecList.add(functionControlSystemSerial);
                Collections.sort(cecList);
            } else {
                Trace.trace(TRACE_MASKD, "create the list and add the cec");
                cecList = new ArrayList<String>(1);
                cecList.add(functionControlSystemSerial);
                Collections.sort(cecList);
                mtmsToCecMapping.put(key, cecList);
            }
        }
        Trace.trace(TRACE_MASKD, "the maps are now");
        Trace.trace(TRACE_MASKD, "mtmsToPortMapping length =" + mtmsToPortMapping.size());
        Trace.trace(TRACE_MASKD, "mtmsToCecMapping length =" + mtmsToCecMapping.size());
        Trace.trace(TRACE_MASKD, "portToMtmsMapping length =" + portToMtmsMapping.size());
    }

    private static void parseFile() {
        try {
            String filePath = BaseFileControl.getFilePath(DEFAULT_RIO_TOPO_PATH);
            if (filePath == null) {
                Trace.trace(TRACE_MASKF, "couldn't find the path in DFC. Use default.");
                filePath = "/opt/esshc/data/config/";
            }
            Trace.trace(TRACE_MASKD, "using " + filePath + " as the path");
            File topoDirectory = new File(filePath);
            File[] files = topoDirectory.listFiles();
            int i = 0;
            while (i < files.length) {
                RioTopologyReader.parseFile(files[i]);
                ++i;
            }
            parsed = true;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    private static void parseFile(String mtms) {
        try {
            mtms = mtms.replace('-', '*');
            mtms = mtms.replace('*', '-');
            String filePath = BaseFileControl.getFilePath(DEFAULT_RIO_TOPO_PATH);
            if (filePath == null) {
                Trace.trace(TRACE_MASKF, "couldn't find the path in DFC. Use default.");
                filePath = "/opt/esshc/data/config/";
            }
            File file = new File(filePath + mtms);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got a file exception");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    private static void parseFile(File topoFile) {
        Trace.trace(TRACE_MASKF, "--> parseFile(File)");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(topoFile));
            String line = reader.readLine();
            while (line != null) {
                int index = line.indexOf("BusNumber:");
                if (index != -1) {
                    Trace.trace(TRACE_MASKD, "found an entry. parse it");
                    RioTopologyReader.parseLoopEntry(line, reader, topoFile);
                }
                line = reader.readLine();
            }
            Trace.trace(TRACE_MASKD, "done reading the file");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    private static void parseFileOrig() {
        try {
            String filePath = BaseFileControl.getFilePath(DEFAULT_RIO_TOPO_PATH);
            if (filePath == null) {
                Trace.trace(TRACE_MASKF, "couldn't find the path in DFC. Use default.");
                filePath = "/home/hscroot/";
            }
            File topoFile = new File(filePath + ORGINAL_CONFIG_FILE_NAME);
            BufferedReader reader = new BufferedReader(new FileReader(topoFile));
            String line = reader.readLine();
            while (line != null) {
                int index = line.indexOf("ManagedSystemMTMS");
                if (index != -1) {
                    Trace.trace(TRACE_MASKD, "found an entry. parse it");
                    RioTopologyReader.parseLoopEntry(line, reader, null);
                }
                line = reader.readLine();
            }
            Trace.trace(TRACE_MASKD, "done reading the file");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    private static void oldcode() {
        block6: {
            String mtms = "";
            String loop = "";
            String leadingPorts = "";
            String trailingPorts = "";
            try {
                File topoFile = new File("currRioCfg");
                BufferedReader reader = new BufferedReader(new FileReader(topoFile));
                String line = reader.readLine();
                int index = line.indexOf("ManagedSystemMTMS");
                if (index == -1) break block6;
                int mtmsIndex = line.indexOf(":");
                mtms = line.substring(mtmsIndex + 1);
                line = reader.readLine();
                if (line.indexOf("Bus Number") != -1) {
                    int busIndex = line.indexOf(":");
                    int externIndex = line.indexOf("Exter");
                    loop = line.substring(busIndex + 1, externIndex);
                    line = reader.readLine();
                    leadingPorts = reader.readLine();
                    line = reader.readLine();
                    trailingPorts = reader.readLine();
                    Trace.trace(TRACE_MASKD, "the mtms info is [" + mtms.trim() + "]");
                    Trace.trace(TRACE_MASKD, "the loop is [" + loop.trim() + "]");
                    Trace.trace(TRACE_MASKD, "leadingPorts is [" + leadingPorts.trim() + "]");
                    Trace.trace(TRACE_MASKD, "trailingPorts is [" + trailingPorts.trim() + "]");
                    ArrayList<Object> portList = new ArrayList<Object>(8);
                    StringTokenizer st = new StringTokenizer(leadingPorts.trim(), ",");
                    while (st.hasMoreElements()) {
                        portList.add(st.nextElement());
                    }
                    st = new StringTokenizer(trailingPorts.trim(), ",");
                    while (st.hasMoreElements()) {
                        portList.add(((String)st.nextElement()).trim());
                    }
                    Collections.sort(portList);
                    Iterator it = portList.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Trace.trace(TRACE_MASKD, "element [" + i + "]=" + it.next());
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKD, "exception opening the file");
                Trace.trace(TRACE_MASKD, e);
            }
        }
    }

    private static void parseLoopEntryOrig(String line, BufferedReader reader) throws IOException {
        int mtmsIndex = line.indexOf(":");
        String mtms = line.substring(mtmsIndex + 1);
        line = reader.readLine();
        if (line.indexOf("Bus Number") != -1) {
            int busIndex = line.indexOf(":");
            int externIndex = line.indexOf("Exter");
            String loop = line.substring(busIndex + 1, externIndex);
            line = reader.readLine();
            String leadingPorts = reader.readLine();
            line = reader.readLine();
            String trailingPorts = reader.readLine();
            ArrayList<Object> portList = new ArrayList<Object>(8);
            StringTokenizer st = new StringTokenizer(leadingPorts.trim(), ",");
            while (st.hasMoreElements()) {
                portList.add(st.nextElement());
            }
            st = new StringTokenizer(trailingPorts.trim(), ",");
            while (st.hasMoreElements()) {
                portList.add(((String)st.nextElement()).trim());
            }
            Collections.sort(portList);
            String key = mtms.trim() + "/" + loop.trim();
            Trace.trace(TRACE_MASKD, "adding loop " + key);
            mtmsToPortMapping.put(key, portList);
            Iterator it = portList.iterator();
            boolean i = false;
        }
    }
}

